unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FMapHandle: THandle;
    FMapPointer: pchar;
    FReadWriteLock: THandle;
    FDataReady: THandle; 
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;

implementation

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.Timer1Timer(Sender: TObject);
   procedure _doGetData;
   var
      _sz: integer;
      _s: string;
      _ms: TMemoryStream;
   begin
      try
         { check if there is unprocessed data }
         if FMapPointer[0] = #1 then
            begin
               { set it as processed }
               FMapPointer[0]:= #0;
               { read the size }
               _sz:= 0;
               move(FMapPointer[1], _sz, 4);
               { allocate a buffer }
               SetLength(_s, _sz);
               { get the data from common memory }
               Move(FMapPointer[5], _s[1], _sz);

               { create the memory stream }
               _ms:= TMemoryStream.Create;
               try
                  { write the msg data }
                  _ms.Write(_s[1], _sz);
                  { go to begining of the file }
                  _ms.Position:= 0;
                  { decode the stream }
                  ReceiveData(_ms);
               finally
                  _ms.Free;
               end;
            end
         else
            ShowMessage('there is unprocessed data');
      finally
         { finish the create lock }
         ReleaseMutex(FReadWriteLock);
      end;
   end;
begin
   { check if there is any data }
   case WaitForSingleObject(FDataReady, 0) of
      WAIT_TIMEOUT: ;
      WAIT_OBJECT_0:
         { try to lock the memory }
         case WaitForSingleObject(FReadWriteLock, 100) of
            WAIT_TIMEOUT: ShowMessage('timed out waiting for lock');
            WAIT_OBJECT_0: _doGetData;
            WAIT_ABANDONED:
               begin
                  ShowMessage('server gone while writing data');
                  _doGetData;
               end;
            else
               RaiseLastWin32Error;
         end;
      else
         RaiseLastWin32Error;
   end;
end;

procedure TfrmMessageReceiver.FormCreate(Sender: TObject);
var
   _s: string;
   _name: string;
begin
   _name:= 'testmap';
   { create the memory map }
   _s:= _name + '.File';
   FMapHandle := CreateFileMapping($FFFFFFFF, nil, PAGE_READWRITE, 0, MEMORYMAPSIZE + 1, PChar(_s));
   if (FMapHandle = 0) then
      RaiseLastWin32Error;
   { get the memory address }
   FMapPointer:= MapViewOfFile(FMapHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);
   { create the read write protection }
   _s:= _name + '.ReadWriteLock';
   FReadWriteLock:= CreateMutex(nil, false, pchar(_s));
   if (FReadWriteLock = 0) then
      RaiseLastWin32Error;
   { data available semaphore }
   _s:= _name + '.Data';
   FDataReady:= CreateSemaphore(nil, 0, MaxInt-1, pchar(_s));
   if (FDataReady = 0) then
      RaiseLastWin32Error;
end;

procedure TfrmMessageReceiver.FormDestroy(Sender: TObject);
begin
   if (FReadWriteLock <> 0) then
      CloseHandle(FReadWriteLock);
   if (FDataReady <> 0) then
      CloseHandle(FDataReady);
   { free the map }
   if (FMapPointer <> nil) then
      UnmapViewOfFile(FMapPointer);
   if (FMapHandle <> 0) then
      CloseHandle(FMapHandle);
end;

end.
